package tech.starwin.mvp.presenter;


import android.text.TextUtils;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.ResponseBody;
import tech.starwin.LibConfig;
import tech.starwin.base.BasePresenter;
import tech.starwin.impl.HttpObserver;
import tech.starwin.mvp.api.LoanApi;

import com.common.bean.HarvestGrantBean;
import com.common.bean.HistoryLoanAppInfoBean;
import com.common.bean.LatestLoanAppBean;
import com.common.bean.ProductBean;

import tech.starwin.utils.context_utils.DeviceUtils;
import tech.starwin.utils.tracker.TrackEvent;

import tech.starwin.utils.LoginManager;
import tech.starwin.utils.PreferencesManager;
import tech.starwin.utils.TrackEventHelper;

/**
 * Created by SiKang on 2018/9/20.
 */
public class LoanPresenter extends BasePresenter<LoanApi> {
    public LoanPresenter() {
        super(LoanApi.class);
    }

    /**
     * 获取贷款额度、贷款周期 可选范围
     */
    public void getLoanRange(String action) {
        handleRequest(action, getApiService().getLoanRange());
    }

    /**
     * 验证贷款资格
     */
    public void checkQualification(String action) {
        handleRequest(action, getApiService().isQualification());
    }

    /**
     * 获取贷款进度
     */
    public void getCertifyProgress(String action) {
        boolean tdFlag = !TextUtils.isEmpty(LibConfig.TONGDUN_PARENT_KEY);
        handleRequest(action, getApiService().getCertifyProgress(tdFlag));
    }

    /**
     * 获取贷款详情
     */
    public void getLoanDetail(String action, ProductBean productBean) {
        handleRequest(action, getApiService().getLoanAmoutData(productBean.getCheckedAmount(), productBean.getCheckedPeriod(), productBean.getPeriodUnit(), productBean.getId()));
    }

    /**
     * 获取最新的贷款申请信息
     */
    public void getLatestLoanApp(String action) {
        DeviceUtils.getInstance().getAppList(LibConfig.getContext());
        handleRequest(action, getApiService().getLatestLoanApp());
    }

    /**
     * 获取贷款记录
     */
    public void getLoanHistory(String action) {
        handleRequest(getApiService().getLoanAppAll(), new HttpObserver<List<HistoryLoanAppInfoBean>>(action) {
            @Override
            public void onStart() {
                view.onHttpStart(action, true);
            }

            @Override
            public void onSuccess(List<HistoryLoanAppInfoBean> data) {
                view.onHttpSuccess(action, data);
            }

            @Override
            public void onError(int code, String msg) {
                view.onHttpError(action, msg);
            }

            @Override
            public void onFinish() {
                view.onHttpFinish(action);
            }
        });
    }


    /**
     * 取消贷款
     */
    public void cancelLoan(String action, String loanAppId) {
        handleRequest(getApiService().cancelLoan(loanAppId),  new HttpObserver<ResponseBody>(action) {
            @Override
            public void onStart() {
                view.onHttpStart(action, true);
            }

            @Override
            public void onSuccess(ResponseBody data) {
                TrackEventHelper.logEvent(TrackEvent.Api.LOAN_CANNELED);
                view.onHttpSuccess(action, data);
            }

            @Override
            public void onError(int code, String msg) {
                view.onHttpError(action, msg);
            }

            @Override
            public void onFinish() {
                view.onHttpFinish(action);
            }
        });
    }


    /**
     * 商品列表
     */
    public void getProductList(String action) {
        if (TextUtils.isEmpty(LoginManager.get().getToken())) {
            handleRequest(action, getApiService().getProductsDefault());
        } else {
            handleRequest(action, getApiService().getProducts());
        }
    }

    /**
     * 获取银行列表
     */

    public void getBankList(String action) {
        handleRequest(action, getApiService().getBankList());
    }


    /**
     * 申请贷款
     */
    public void applyLoan(String action, LatestLoanAppBean loanInfo) {
        Observable<ResponseBody> observable = getApiService().addBank(loanInfo.getLoanAppId(),
                loanInfo.getBankCode(),
                loanInfo.getCardNo(),
                loanInfo.getApplyFor(),
                loanInfo.getApplyChannel(),
                "ANDROID",
                loanInfo.getCouponId());

        handleRequest(observable, new HttpObserver<ResponseBody>(action) {
            @Override
            public void onStart() {
                view.onHttpStart(action, true);
            }

            @Override
            public void onSuccess(ResponseBody data) {
                TrackEventHelper.logEvent(TrackEvent.Api.BANK_INFO_SUBMITED);
                view.onHttpSuccess(action, data);
            }

            @Override
            public void onError(int code, String msg) {
                view.onHttpError(action, msg);
            }

            @Override
            public void onFinish() {
                view.onHttpFinish(action);
            }
        });
    }

    /**
     * 获取付款方式
     */
    public void getDepostMethods(String action) {
        handleRequest(action, getApiService().getDepostMethods());
    }


    /**
     * 是否授权数据
     */
    public void getHarvestGrant(String action) {
        handleRequest(action, getApiService().getHarvestGrant());
    }


    /**
     * 创建还款订单
     */
    public void getRepayOrder(String action, LatestLoanAppBean loanAppBean, final double payAmount, final String repayMethodorBank) {
        handleRequest(action,
                getApiService().getRepayOrder(loanAppBean.getLoanAppId(),
                        "IDR",
                        repayMethodorBank,
                        payAmount
                ));
    }

}
