package tech.starwin.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.Base64;

import com.qmuiteam.qmui.QMUILog;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import tech.starwin.R;

/**
 * Created by SiKang on 2018/9/17.
 * 常用工具
 */
public class GeneralUtils {

    /**
     * List是否无内容
     */
    public static boolean isEmpty(List list) {
        if (list == null || list.size() == 0)
            return true;
        return false;
    }

    /**
     * 是否有空值
     */
    public static boolean hasEmpty(String value, String... values) {
        if (TextUtils.isEmpty(value)) {
            return true;
        } else {
            for (String str : values) {
                if (TextUtils.isEmpty(str)) {
                    return true;
                }
            }
        }

        return false;
    }


    public static void findAndModifyOpInBackStackRecord(FragmentManager fragmentManager, int backStackIndex, OPHandler handler) {
        if (fragmentManager == null || handler == null) {
            return;
        }
        int backStackCount = fragmentManager.getBackStackEntryCount();
        if (backStackCount > 0) {
            if (backStackIndex >= backStackCount || backStackIndex < -backStackCount) {
                QMUILog.d("findAndModifyOpInBackStackRecord", "backStackIndex error: " +
                        "backStackIndex = " + backStackIndex + " ; backStackCount = " + backStackCount);
                return;
            }
            if (backStackIndex < 0) {
                backStackIndex = backStackCount + backStackIndex;
            }
            try {
                FragmentManager.BackStackEntry backStackEntry = fragmentManager.getBackStackEntryAt(backStackIndex);

                Field opsField = backStackEntry.getClass().getDeclaredField("mOps");
                opsField.setAccessible(true);
                Object opsObj = opsField.get(backStackEntry);
                if (opsObj instanceof List<?>) {
                    List<?> ops = (List<?>) opsObj;
                    for (Object op : ops) {
                        if (handler.handle(op)) {
                            return;
                        }
                    }
                }
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public interface OPHandler {
        boolean handle(Object op);
    }
}
