package tech.starwin.mvp;

import com.trello.rxlifecycle2.LifecycleProvider;
import com.trello.rxlifecycle2.android.ActivityEvent;


/**
 * Created by SiKang on 2018/9/14.
 *
 */
public interface IView extends LifecycleProvider<ActivityEvent> {

    /**
     * 请求开始
     */
    void onHttpStart(String action, boolean isShowLoading);

    /**
     * 响应成功，数据正常返回
     */
    void onHttpSuccess(String action, Object result);

    /**
     * 请求出现错误
     */
    void onHttpError(String action, String msg);

    /**
     * 请求结束
     */
    void onHttpFinish(String action);

}
