package tech.starwin.mvp.presenter;


import android.text.TextUtils;

import tech.starwin.base.BasePresenter;
import tech.starwin.mvp.api.LoanApi;
import tech.starwin.mvp.beans.LatestLoanAppBean;
import tech.starwin.mvp.beans.ProductBean;
import tech.starwin.utils.LoginManager;

/**
 * Created by SiKang on 2018/9/20.
 */
public class LoanPresenter extends BasePresenter<LoanApi> {
    public LoanPresenter() {
        super(LoanApi.class);
    }

    /**
     * 获取贷款额度、贷款周期 可选范围
     */
    public void getLoanRange(String action) {
        handleRequest(action, apiService.getLoanRange());
    }

    /**
     * 验证贷款资格
     */
    public void checkQualification(String action) {
        handleRequest(action, apiService.isQualification(LoginManager.get().getToken()));
    }

    /**
     * 获取贷款进度
     */
    public void getCertifyProgress(String action) {
        handleRequest(action, apiService.getCertifyProgress(LoginManager.get().getToken()));
    }

    /**
     * 获取贷款详情
     */
    public void getLoanDetail(String action, ProductBean productBean) {
        handleRequest(action, apiService.getLoanAmoutData(productBean.getCheckedAmount(), productBean.getCheckedPeriod(), productBean.getPeriodUnit(), productBean.getId()));
    }

    /**
     * 获取最新的贷款申请信息
     */
    public void getLatestLoanApp(String action) {
        handleRequest(action, apiService.getLatestLoanApp(LoginManager.get().getToken()));
    }

    /**
     * 获取贷款记录
     */
    public void getLoanHistory(String action) {
        handleRequest(action, apiService.getLoanAppAll(LoginManager.get().getToken()));
    }


    /**
     * 取消贷款
     */
    public void cancelLoan(String action, String loanAppId) {
        handleRequest(action, apiService.cancelLoan(loanAppId, LoginManager.get().getToken()));
    }


    /**
     * 商品列表
     */
    public void getProductList(String action) {
        handleRequest(action, apiService.getProductsDefault());
    }


    /**
     * 获取银行列表
     */

    public void getBankList(String action) {
        handleRequest(action, apiService.getBankList());
    }


    /**
     * 申请贷款
     */
    public void applyLoan(String action, LatestLoanAppBean loanInfo) {
        handleRequest(action,
                apiService.addBank(loanInfo.getLoanAppId(),
                        loanInfo.getBankCode(),
                        loanInfo.getCardNo(),
                        loanInfo.getApplyFor(),
                        loanInfo.getApplyChannel(),
                        "ANDROID",
                        loanInfo.getCouponId(),
                        LoginManager.get().getToken())
        );
    }

    /**
     * 获取付款方式
     */
    public void getDepostMethods(String action) {
        handleRequest(action, apiService.getDepostMethods(LoginManager.get().getToken()));
    }


    /**
     * 创建还款订单
     */
    public void getRepayOrder(String action, LatestLoanAppBean loanAppBean, final double payAmount, final String repayMethodorBank) {
        handleRequest(action,
                apiService.getRepayOrder(loanAppBean.getLoanAppId(),
                        "IDR",
                        repayMethodorBank,
                        payAmount,
                        LoginManager.get().getToken()
                ));
    }

}
