package tech.starwin.mvp.ui.activity;

import android.content.Intent;
import android.graphics.Bitmap;
import android.support.annotation.DrawableRes;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;

import com.wonderkiln.camerakit.CameraKitError;
import com.wonderkiln.camerakit.CameraKitEvent;
import com.wonderkiln.camerakit.CameraKitEventListener;
import com.wonderkiln.camerakit.CameraKitImage;
import com.wonderkiln.camerakit.CameraKitVideo;
import com.wonderkiln.camerakit.CameraView;

import java.io.File;

import tech.starwin.R;
import tech.starwin.base.BaseActivity;
import tech.starwin.impl.OnEventClickListener;
import tech.starwin.utils.BitmapUtils;
import tech.starwin.utils.FileUtils;
import tech.starwin.utils.context_utils.ActivityJumper;
import tech.starwin.utils.context_utils.EasyActivityResult;
import tech.starwin.utils.ui_utils.UIHelper;

/**
 * Created by SiKang on 2018/9/25.
 */
public class TakePhotoActivity extends BaseActivity {
    public enum PhotoType {
        KTP,
        WORK_CARD
    }

    public static void startForResult(FragmentActivity activity, int requestCode, PhotoType type, @DrawableRes int previewMask, @DrawableRes int shootBtnImg, EasyActivityResult.OnResultListener result) {
        Intent intent = new ActivityJumper.Builder(activity, TakePhotoActivity.class)
                .put("photo_type", type.name())
                .put("preview_mask", previewMask)
                .put("shoot_btn_img", shootBtnImg)
                .toIntent();
        new EasyActivityResult(activity).startForResult(intent, requestCode, result);
    }


    ImageView btnCapture;
    ImageView maskImv;
    Button mbtnCancel;
    CameraView cameraView;

    public static String KTP_IMAGE = "ktp_img.jpg";

    private static final int PHOTO_FILE_SIZE_MAX = 2 * 1024 * 1024;
    final int BITMAP_MAX_SQUARE_SIZE = 3920;

    @Override
    public int bindLayout() {
        return R.layout.activity_take_photo;
    }


    @Override
    public void initView() {
        btnCapture = findViewById(R.id.button_shoot);
        mbtnCancel = findViewById(R.id.button_cancel);
        cameraView = findViewById(R.id.cameraView);
        maskImv = findViewById(R.id.activity_takephoto_mask_imv);

        int mask = getIntent().getIntExtra("preview_mask", 0);
        int btnImg = getIntent().getIntExtra("shoot_btn_img", 0);
        if (mask != 0) {
            maskImv.setImageResource(mask);
        }
        if (btnImg != 0) {
            btnCapture.setImageResource(btnImg);
        }
        String type = getIntent().getStringExtra("photo_type");
        if (TextUtils.equals(type, PhotoType.KTP.name())) {
            findViewById(R.id.imageview_id_frame).setVisibility(View.VISIBLE);
        }

        UIHelper.bindClickListener(new OnEventClickListener() {
            @Override
            public void onEventClick(View v) {
                if (v.getId() == R.id.button_shoot) {
                    cameraView.captureImage();
                } else if (v.getId() == R.id.button_cancel) {
                    setResult(RESULT_CANCELED);
                    finish();
                }
            }
        }, mbtnCancel, btnCapture);

        //拍照监听
        cameraView.addCameraKitListener(new CameraKitEventListener() {
            @Override
            public void onEvent(CameraKitEvent cameraKitEvent) {

            }

            @Override
            public void onError(CameraKitError cameraKitError) {
            }

            @Override
            public void onImage(CameraKitImage cameraKitImage) {
                Bitmap bitmap = BitmapUtils.getBitmapWithMaxLimit(cameraKitImage.getJpeg(), BITMAP_MAX_SQUARE_SIZE, PHOTO_FILE_SIZE_MAX);
                File image = FileUtils.getImageFile(getApplicationContext(), KTP_IMAGE);
                if (!image.exists()) {
                    image.mkdir();
                }
                BitmapUtils.saveBitmapToSDCard(BitmapUtils.getHorizontalPhoto(bitmap), image, 80);
                Intent intent = new Intent();
                intent.putExtra("image_path", image.getAbsolutePath());
                setResult(RESULT_OK, intent);
                finish();
            }

            @Override
            public void onVideo(CameraKitVideo cameraKitVideo) {

            }
        });
    }


    @Override
    protected void onStart() {
        super.onStart();
        cameraView.start();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onStop() {
        super.onStop();
        cameraView.stop();
    }

    @Override
    public void onHttpSuccess(String action, Object result) {

    }
}
