package tech.starwin.mvp.ui.activity;

import android.content.Context;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;

import tech.starwin.R;
import tech.starwin.base.BaseActivity;
import tech.starwin.utils.context_utils.ActivityJumper;

/**
 * Created by SiKang on 2018/11/19.
 */
public class WebActivity extends BaseActivity {

    public static void start(Context context, String title, String url) {
        new ActivityJumper.Builder(context, WebActivity.class)
                .put("title", title)
                .put("url", url)
                .build().start();
    }

    WebView webView;


    @Override
    public int bindLayout() {
        return R.layout.activity_web;
    }

    @Override
    public void initView() {
        String url = getIntent().getStringExtra("url");
        String title = getIntent().getStringExtra("title");

        setTopBarTitle(title);

        webView = findViewById(R.id.activity_web_wv);
        WebSettings seting=webView.getSettings();
        seting.setJavaScriptEnabled(true);//设置webview支持javascript脚本

        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    onHttpFinish("");
                } else {
                    onHttpStart("", true);
                }

            }
        });

        webView.loadUrl(url);
    }

    @Override
    public void onHttpSuccess(String action, Object result) {

    }
}
