package tech.starwin.utils.format_utils;

import android.content.Context;

import tech.starwin.R;
import tech.starwin.utils.format_utils.StringAdapter;


/**
 * Created by SiKang on 2018/10/17.
 * 与服务器通信的文本 和 展示给用户的文本，相互转换
 */
public class InfoTranslator {

    /**
     * 性别text
     */
    public static StringAdapter getGenderAdapter(Context context) {
        StringAdapter adapter = new StringAdapter();
        adapter.addItem(newItem(context, "MALE", R.string.enum_gender_male));
        adapter.addItem(newItem(context, "FEMALE", R.string.enum_gender_female));
        return adapter;
    }

    public static String getGenderValue(Context context, String info) {
        return getGenderAdapter(context).getItemValue(info);
    }

    public static String getGenderInfo(Context context, String value) {
        return getGenderAdapter(context).getItemInfoStr(value);
    }


    /**
     * 婚姻
     */
    public static StringAdapter getMaritalAdapter(Context context) {
        StringAdapter adapter = new StringAdapter();
        adapter.addItem(newItem(context, "SINGLE", R.string.enum_marriage_single));
        adapter.addItem(newItem(context, "MARRIED", R.string.enum_marriage_married));
        adapter.addItem(newItem(context, "DIVORCED", R.string.enum_marriage_divorced));
        adapter.addItem(newItem(context, "WIDOWED", R.string.enum_marriage_widowed));
        return adapter;
    }

    public static String getMaritalValue(Context context, String info) {
        return getMaritalAdapter(context).getItemValue(info);
    }

    public static String getMaritalInfo(Context context, String value) {
        return getMaritalAdapter(context).getItemInfoStr(value);
    }


    /**
     * 生育
     */
    public static StringAdapter getChildrenCountAdapter(Context context) {
        StringAdapter adapter = new StringAdapter();
        adapter.addItem(newItem(context, "ZERO", R.string.enum_children_zero));
        adapter.addItem(newItem(context, "ONE", R.string.enum_children_one));
        adapter.addItem(newItem(context, "TWO", R.string.enum_children_two));
        adapter.addItem(newItem(context, "THREE", R.string.enum_children_three));
        adapter.addItem(newItem(context, "FOUR", R.string.enum_children_four));
        adapter.addItem(newItem(context, "OVER_FOUR", R.string.enum_children_overfour));
        return adapter;
    }

    public static String getChildrenCountValue(Context context, String info) {
        return getChildrenCountAdapter(context).getItemValue(info);
    }

    public static String getChildrenCountInfo(Context context, String value) {
        return getChildrenCountAdapter(context).getItemInfoStr(value);
    }


    /**
     * 学历
     */
    public static StringAdapter getDurationAdapter(Context context) {
        StringAdapter adapter = new StringAdapter();
        adapter.addItem(newItem(context, "THREE_MONTH", R.string.enum_period_three_month));
        adapter.addItem(newItem(context, "SIX_MONTH", R.string.enum_period_six_month));
        adapter.addItem(newItem(context, "ONE_YEAR", R.string.enum_period_one_year));
        adapter.addItem(newItem(context, "TWO_YEAR", R.string.enum_period_two_year));
        adapter.addItem(newItem(context, "OVER_TWO_YEAR", R.string.enum_period_over_two_year));
        return adapter;
    }

    public static String getDurationValue(Context context, String info) {
        return getDurationAdapter(context).getItemValue(info);
    }

    public static String getDurationInfo(Context context, String value) {
        return getDurationAdapter(context).getItemInfoStr(value);
    }

    /**
     * 薪水
     */
    public static StringAdapter getSalaryAdapter(Context context) {
        StringAdapter adapter = new StringAdapter();
        adapter.addItem(newItem(context, "BELOW_2M", R.string.enum_salary_below_2b));
        adapter.addItem(newItem(context, "BETWEEN_2M_4M", R.string.enum_salary_between_2b_4b));
        adapter.addItem(newItem(context, "BETWEEN_4M_8M", R.string.enum_salary_between_4b_8b));
        adapter.addItem(newItem(context, "OVER_8M", R.string.enum_salary_over_8b));
        return adapter;
    }

    public static String getSalaryValue(Context context, String info) {
        return getSalaryAdapter(context).getItemValue(info);
    }

    public static String getSalaryInfo(Context context, String value) {
        return getSalaryAdapter(context).getItemInfoStr(value);
    }


    /**
     * 工作状态
     */
    public static StringAdapter getJobStatusAdapter(Context context) {
        StringAdapter adapter = new StringAdapter();
        adapter.addItem(newItem(context, "ACCOUNTING", R.string.enum_job_accounting));
        adapter.addItem(newItem(context, "WAITER", R.string.enum_job_waiter));
        adapter.addItem(newItem(context, "ENGINEER", R.string.enum_job_engineer));
        adapter.addItem(newItem(context, "EXECUTIVE", R.string.enum_job_executive));
        adapter.addItem(newItem(context, "GENERAL_ADMINISTRATION", R.string.enum_job_general_administration));
        adapter.addItem(newItem(context, "INFORMATION_TECHNOLOGY", R.string.enum_job_information_technology));
        adapter.addItem(newItem(context, "CONSULTANT", R.string.enum_job_consultant));
        adapter.addItem(newItem(context, "MARKETING", R.string.enum_job_marketing));
        adapter.addItem(newItem(context, "TEACHER", R.string.enum_job_teacher));
        adapter.addItem(newItem(context, "MILITARY", R.string.enum_job_military));
        adapter.addItem(newItem(context, "RETIRED", R.string.enum_job_retired));
        adapter.addItem(newItem(context, "STUDENT", R.string.enum_job_student));
        adapter.addItem(newItem(context, "ENTREPRENEUR", R.string.enum_job_entrepreneur));
        adapter.addItem(newItem(context, "POLICE", R.string.enum_job_police));
        adapter.addItem(newItem(context, "FARMER", R.string.enum_job_farmer));
        adapter.addItem(newItem(context, "FISHERMAN", R.string.enum_job_fisherman));
        adapter.addItem(newItem(context, "BREEDER", R.string.enum_job_breeder));
        adapter.addItem(newItem(context, "DOCTOR", R.string.enum_job_doctor));
        adapter.addItem(newItem(context, "MEDICAL_PERSONNEL", R.string.enum_job_medical_personal));
        adapter.addItem(newItem(context, "LAWYER", R.string.enum_job_lawyer));
        adapter.addItem(newItem(context, "CHEF", R.string.enum_job_chef));
        adapter.addItem(newItem(context, "RESEARCHER", R.string.enum_job_research));
        adapter.addItem(newItem(context, "DESIGNER", R.string.enum_job_designer));
        adapter.addItem(newItem(context, "ARCHITECT", R.string.enum_job_architect));
        adapter.addItem(newItem(context, "WORKERS_ART", R.string.enum_job_workers_art));
        adapter.addItem(newItem(context, "SECURITY", R.string.enum_job_security));
        adapter.addItem(newItem(context, "BROKER", R.string.enum_job_broker));
        adapter.addItem(newItem(context, "DISTRIBUTOR", R.string.enum_job_distributor));
        adapter.addItem(newItem(context, "AIR_TRANSPORTATION", R.string.enum_job_air_transportation));
        adapter.addItem(newItem(context, "SEA_TRANSPORTATION", R.string.enum_job_sea_transportation));
        adapter.addItem(newItem(context, "LAND_TRANSPORTATION", R.string.enum_job_land_transportation));
        adapter.addItem(newItem(context, "LABOR", R.string.enum_job_labor));
        adapter.addItem(newItem(context, "CRAFTSMAN", R.string.enum_job_craftsman));
        adapter.addItem(newItem(context, "HOUSEWIFE", R.string.enum_job_housewife));
        adapter.addItem(newItem(context, "STATE_OFFICIALS", R.string.enum_job_state_officials));
        adapter.addItem(newItem(context, "GOVERNMENT_EMPLOYEE", R.string.enum_job_government_employment));
        adapter.addItem(newItem(context, "INFORMAL_WORKERS", R.string.enum_job_information_worker));
        adapter.addItem(newItem(context, "OTHER", R.string.enum_job_other));
        return adapter;
    }

    public static String getJobSatusValue(Context context, String info) {
        return getJobStatusAdapter(context).getItemValue(info);
    }

    public static String getJobStatusInfo(Context context, String value) {
        return getJobStatusAdapter(context).getItemInfoStr(value);
    }


    /**
     * 还款方式
     */
    public static StringAdapter getRepayMethodAdapter(Context context) {
        StringAdapter adapter = new StringAdapter();
        adapter.addItem(newItem(context, "ALFAMART", R.string.pay_in_alfamart_title));
        adapter.addItem(newItem(context, "BCA", R.string.bca_title));
        adapter.addItem(newItem(context, "MANDIRI", R.string.mandiri_title));
        adapter.addItem(newItem(context, "BNI", R.string.bni_title));
        adapter.addItem(newItem(context, "BRI", R.string.bri_title));
        adapter.addItem(newItem(context, "OTHERS", R.string.other_banks_title));
        return adapter;
    }

    public static String getRepayMethodValue(Context context, String info) {
        return getRepayMethodAdapter(context).getItemValue(info);
    }

    public static String getRepayMethodInfo(Context context, String value) {

        return getRepayMethodAdapter(context).getItemInfoStr(value);
    }


    private static StringAdapter.Item newItem(Context context, String value, int info) {
        return new StringAdapter.Item(value, context.getString(info));
    }


}
