package tech.starwin.mvp.ui.adapter;

import android.content.Context;
import android.view.View;

import com.common.bean.ProductBean;

import java.util.List;

import tech.starwin.R;
import tech.starwin.base.BaseRecyclerAdapter;
import tech.starwin.base.RecyclerViewHolder;
import tech.starwin.utils.format_utils.StringFormat;

/**
 * Created by SiKang on 2018/11/15.
 */
public class ReviewProductAdapter extends BaseRecyclerAdapter<ProductBean> {
    public ReviewProductAdapter(Context ctx, List<ProductBean> list) {
        super(ctx, list);
    }

    @Override
    public Object bindItemLayout() {
        return R.layout.item_review_product;
    }

    @Override
    public void bindData(RecyclerViewHolder holder, int position, ProductBean item) {
        holder.getTextView(R.id.item_review_product_productName_tv).setText(item.getName() + " - Bunga: 0.038% / Hari");
        //额度
        String amount;
        if (item.getMaxAmount() - item.getMinAmount() < 1 ) {
            amount = StringFormat.moneyFormat(getContext(), item.getMinAmount());
        } else {
            amount = StringFormat.moneyFormat(getContext(), item.getMinAmount()) + " | " + StringFormat.moneyFormat(getContext(), item.getMaxAmount());
        }
        holder.getTextView(R.id.item_review_product_amount_tv).setText(amount);
        //还款期限
        String period;
        if (item.getMaxPeriod() == item.getMinPeriod()) {
            period = StringFormat.periodFormat(getContext(), item.getMinPeriod(), item.getPeriodUnit());
        } else {
            period = StringFormat.periodFormat(getContext(), item.getMinPeriod(), item.getPeriodUnit()) + " | " + StringFormat.periodFormat(getContext(), item.getMaxPeriod(), item.getPeriodUnit());
        }
        holder.getTextView(R.id.item_review_product_time_tv).setText(period);


    }

}
