package com.common.activity;

import android.content.Context;

import java.util.ArrayList;
import java.util.List;

import tech.starwin.R;
import com.common.base.BaseActivity;
import com.common.bean.RepaymentGuideBean;
import tech.starwin.mvp.ui.adapter.RepaymentGuideAdapter;
import tech.starwin.utils.context_utils.ActivityJumper;
import tech.starwin.utils.ui_utils.UIHelper;
import com.common.widget.TopBar;

/**
 * Created by SiKang on 2018/11/17.
 */
public class RepaymentGuideActivity extends BaseActivity {

    public static void start(Context context) {
        new ActivityJumper.Builder(context, RepaymentGuideActivity.class).build().start();
    }

    @Override
    protected void initTopBar(TopBar topBar) {
        super.initTopBar(topBar);
        topBar.toolBar().setTitle(R.string.text_title_repaymentraiders);
    }

    @Override
    public int bindLayout() {
        return R.layout.activity_repayment_guide;
    }

    @Override
    public void initView() {
        String[] titles = getResources().getStringArray(R.array.text_repayment_raiders_instruction_title);
        String[] details = getResources().getStringArray(R.array.text_repayment_raiders_instruction_detail);
        List<RepaymentGuideBean> guideBeanList = new ArrayList<>(titles.length);
        for (int i = 0; i < titles.length; i++) {
            guideBeanList.add(new RepaymentGuideBean(titles[i], details[i]));
        }
        UIHelper.bindAdapter(findViewById(R.id.activity_repaymentGuide_tv), new RepaymentGuideAdapter(this, guideBeanList));
    }

    @Override
    public void onHttpSuccess(String action, Object result) {

    }
}
