package tech.starwin.utils.context_utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.Telephony;
import android.text.TextWatcher;
import android.view.View;

import java.io.Serializable;
import java.util.List;

import tech.starwin.LibConfig;
import tech.starwin.R;
import tech.starwin.utils.ui_utils.DialogFactory;
import tech.starwin.utils.ui_utils.DialogManager;

/**
 * Created by SiKang on 2018/9/16.
 * Intent的创建和使用
 */
public class ActivityJumper {
    private static String GP_APP_DETAIL_URL = "https://play.google.com/store/apps/details?id=";
    private Intent intent;
    /**
     * 发起跳转的Context
     */
    private Context context;

    private ActivityJumper(Context from, Intent intent) {
        this.intent = intent;
        this.context = from;
    }

    /**
     * 打开Activity
     */
    public void start() {
        if (context == null) {
            return;
        }
        context.startActivity(intent);
    }

    /**
     * 在新的Task种打开Activity
     */
    public void startWithNewTask() {
        if (context == null)
            return;
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }


    public Intent getIntent() {
        return intent;
    }

    /**
     * 启动拨号键盘
     */
    public static void startCallTel(Context context, String tel) {
        Intent intent = new Intent(Intent.ACTION_DIAL);
        Uri data = Uri.parse("tel:" + tel);
        intent.setData(data);
        context.startActivity(intent);
    }

    /**
     * 发短信界面
     */
    public static void startSendTo(Context context, String tel, String smsBody) {
        Uri sms_uri = Uri.parse("smsto:13517596490");//设置号码
        Intent intent = new Intent(Intent.ACTION_SENDTO, sms_uri);//调用发短信Action
        intent.putExtra("sms_body", smsBody);
        context.startActivity(intent);
    }


    /**
     * 短信列表界面
     */
    public static void startSmsList(Context context) {
        Intent intent = new Intent(Intent.ACTION_MAIN);
        intent.addCategory(Intent.CATEGORY_DEFAULT);
        intent.setType("vnd.android-dir/mms-sms");
        context.startActivity(intent);
    }

    /**
     * 去 GooglePlay下载页
     */
    public static void startGooglePlay(Context context) {
        startGooglePlay(context, LibConfig.APPLICATION_ID);
    }

    public static void startGooglePlay(Context context, String packageName) {
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(GP_APP_DETAIL_URL + packageName));
            List<ResolveInfo> resolveInfos = context.getPackageManager().queryIntentActivities(intent, 0);
            if (resolveInfos != null && resolveInfos.size() > 0) {
                for (ResolveInfo resolveInfo : resolveInfos) {
                    if (resolveInfo.activityInfo.packageName.toLowerCase().contains("com.android.vending")
                            || resolveInfo.activityInfo.name.toLowerCase().contains("com.android.vending")
                            || resolveInfo.activityInfo.processName.toLowerCase().contains("com.android.vending")) {
                        intent.setPackage(resolveInfo.activityInfo.packageName);
                        break;
                    }
                }
            }
            context.startActivity(intent);
        } catch (Exception e) {
            DialogFactory.showMessageDialog(context, context.getString(R.string.show_download_on_google_player));
        }
    }


    public static class Builder {
        private Intent intent;
        private Context fromContext;

        public Builder() {
            intent = new Intent();
        }

        public <C extends Activity> Builder(Context from, Class<C> target) {
            this.fromContext = from;
            intent = new Intent(fromContext, target);
        }

        public Builder(Context from, String action) {
            this.fromContext = from;
            intent = new Intent(action);
        }

        public Builder put(String key, String value) {
            intent.putExtra(key, value);
            return this;
        }

        public Builder put(String key, int value) {
            intent.putExtra(key, value);
            return this;
        }

        public Builder put(String key, float value) {
            intent.putExtra(key, value);
            return this;
        }

        public Builder put(String key, double value) {
            intent.putExtra(key, value);
            return this;
        }

        public Builder put(String key, boolean value) {
            intent.putExtra(key, value);
            return this;
        }

        public Builder put(String key, Serializable obj) {
            intent.putExtra(key, obj);
            return this;
        }

        public Builder put(String key, Parcelable obj) {
            intent.putExtra(key, obj);
            return this;
        }

        public ActivityJumper build() {
            return new ActivityJumper(fromContext, intent);
        }

        public Intent toIntent() {
            return intent;
        }

        public Bundle toBundle() {
            return intent.getExtras();
        }
    }

}

