package tech.starwin.mvp.ui.activity;

import android.content.Context;

import java.util.List;

import tech.starwin.R;
import tech.starwin.base.BaseActivity;
import tech.starwin.mvp.beans.MsgInboxBean;
import tech.starwin.mvp.presenter.UserPresenter;
import tech.starwin.mvp.ui.adapter.MessageAdapter;
import tech.starwin.utils.context_utils.ActivityJumper;
import tech.starwin.utils.ui_utils.UIHelper;

/**
 * Created by SiKang on 2018/11/20.
 */
public class MessageListActivity extends BaseActivity {

    public static void start(Context context) {
        new ActivityJumper.Builder(context, MessageListActivity.class).build().start();
    }

    @Override
    public int bindLayout() {
        return R.layout.simple_recyclerview;
    }

    @Override
    public void initView() {
        setTopBarTitle(getString(R.string.text_title_system_message));
        getPresenter(UserPresenter.class).getMsgList("action_getMsgList");
    }

    @Override
    public void onHttpSuccess(String action, Object result) {
        if (action.equals("action_getMsgList")) {
            List<MsgInboxBean> msgInboxBeans = (List<MsgInboxBean>) result;
            UIHelper.bindAdapter(findViewById(R.id.simple_recyclerview), new MessageAdapter(MessageListActivity.this, msgInboxBeans));
        }

    }
}
