import random
import os
from tools.garbel.class_builder import ClassBuilder

class ManifestGarble:
    __used_names = []
    def __gen_rand_str(self):
        result = ""
        while len(result) == 0 or result in self.__used_names:
            random_str = ''.join(random.sample(
                "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", random.randint(6, 10)))
            result = "%s%d" % (random_str, random.randint(101, 200))
        self.__used_names.append(result)
        return result

    #在包中随机创建Activity
    def __create_activities(self,path):
        activities = []
        for root, dirs, files in os.walk(path):
            if len(files) > 0:
                for i in range(0,random.randint(3,10)):
                    act_name = self.__gen_rand_str()
                    act_path = "%s/%s.java"%(root, act_name) 
                    pkg_name = root.split("main/java/")[1].replace("/",".")
                    act_content = ClassBuilder().new_class(act_name,pkg_name)
                    with open(act_path, "w+", encoding="utf-8") as fout:
                        fout.write(act_content)
                    activities.append("%s.%s"%(pkg_name,act_name))
        return activities

    
    def manifest_garbel(self, config):
        self.__create_activities("%s/app/src/main/java"%config["root"])
        # self.__create_activities("%s/app/src/main/java"%config["root"])