#!/usr/bin/env python3
import json
import string
import random
import glob, os

used_names = []
activity_mangle_setting = {}


# rand string for class names
def gen_rand_str():
    rand_str = ''.join(random.choices(string.ascii_uppercase + string.ascii_lowercase, k=8))
    while rand_str in used_names:
        rand_str = ''.join(random.choices(string.ascii_uppercase + string.ascii_lowercase, k=8))

    used_names.append(rand_str)
    return rand_str


def get_rand_code(index):
    code = ""
    if index == 0:
        code += ";\nString " + gen_rand_str() + "=\"" + gen_rand_str() + "\"\n;"
    return code


def process_file_content(path, file_name):
    print("processing content: %s..." % path)
    with open(path, "r", encoding="utf-8") as f:
        # readlines以列表的形式将文件读出
        lines = f.readlines()

    with open(path, "w", encoding="utf-8") as f_w:
        for line in lines:
            if ";\n" in line:
                line = line.replace(";\n", get_rand_code(0))
            f_w.write(line)
        print("done\n")
    return

# read configs
with open('obact.json', "rt") as f:
    json_root = json.load(f)
    activities = json_root["activities"]
    source_root = json_root["root"]
    manifest = json_root["manifest"]

# mangle activity names
for act_name in activities:
    activity_mangle_setting[act_name] = gen_rand_str()

root_path = os.path.join(os.getcwd(), source_root)
# perform content replace for the files
print("processing file content...")
for root, dirs, files in os.walk(source_root):
    directory = os.path.join(os.getcwd(), root)
    for file in files:
        if file.endswith(".java"):
            # get the path of the java file
            path = os.path.join(directory, file)

            process_file_content(path, file)
print("processing file content done")
