package tech.starwin.common.service;


import android.content.Context;
import android.content.Intent;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;

import org.greenrobot.eventbus.EventBus;


/**
 * Created by SiKang on 2018/9/27.
 */
public class MsgHandleService extends FirebaseMessagingService {
    public static final String TAG = "MsgHandleService";
    public static final String RECEIVED_FIREBASE_MESSAGE = "action.receivedFireBaseMessage";

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        handleMsg(this, remoteMessage);
    }

    @Override
    public void onDeletedMessages() {
    }

    /**
     * 处理推送内容
     */
    public static void handleMsg(Context context, RemoteMessage remoteMessage) {
        if (remoteMessage != null) {
            //EventBus通知
            EventBus.getDefault().post(remoteMessage);

            //广播形式通知
            Intent intent = remoteMessage.toIntent();
            intent.setAction(RECEIVED_FIREBASE_MESSAGE);
            context.sendBroadcast(intent);
        }
    }

}
