package tech.starwin.mvp.beans;

import com.google.gson.annotations.SerializedName;

import java.io.Serializable;
import java.util.List;

public class GatewayInfoBean implements Serializable {
    private static final long serialVersionUID = -6527836006943252482L;

    @SerializedName("gateway")
    public List<String> gateway;

    @SerializedName("rest")
    public List<String> rest;

    @SerializedName("harvester")
    public List<String> harvester;

    @SerializedName("admin")
    public List<String> admin;

    @SerializedName("privacy")
    public List<String> privacy;

    @Override
    public String toString() {
        return "GatewayInfoBean{" +
                "gateway=" + gateway +
                ", rest=" + rest +
                ", harvester=" + harvester +
                ", admin=" + admin +
                ", privacy=" + privacy +
                '}';
    }

    public void notifyWith(GatewayInfoBean gatewayInfo) {
        if (gatewayInfo == null) {
            return;
        }
        if (gatewayInfo.gateway != null && gatewayInfo.gateway.size() > 0) {
            gateway = gatewayInfo.gateway;
        }
        if (gatewayInfo.rest != null && gatewayInfo.rest.size() > 0) {
            rest = gatewayInfo.rest;
        }
        if (gatewayInfo.harvester != null && gatewayInfo.harvester.size() > 0) {
            harvester = gatewayInfo.harvester;
        }
        if (gatewayInfo.admin != null && gatewayInfo.admin.size() > 0) {
            admin = gatewayInfo.admin;
        }
        if (gatewayInfo.privacy != null && gatewayInfo.privacy.size() > 0) {
            privacy = gatewayInfo.privacy;
        }
    }


}
