package tech.starwin.widget;

import android.animation.ObjectAnimator;
import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;

import tech.starwin.LibConfig;
import tech.starwin.R;

/**
 * Created by SiKang on 2018/9/19.
 */
public class LoadDialog extends Dialog {
    private ObjectAnimator mLoadAnimation;

    public LoadDialog(@NonNull Context context) {
        super(context, R.style.style_bg_transparent_dialog);
        View view = LayoutInflater.from(context).inflate(R.layout.base_progress_loading, null, false);
        setContentView(view);
        setCanceledOnTouchOutside(false);
        ImageView rotationView = view.findViewById(R.id.progress_dialog_loadingImv);
        ImageView iconView = view.findViewById(R.id.progress_dialog_iconImv);
        rotationView.setImageResource(LibConfig.LOADING_BACKGROUND);
        iconView.setImageResource(LibConfig.LOADING_ICON);
        //初始化动画
        mLoadAnimation = ObjectAnimator.ofFloat(rotationView, "rotation", 0, 360);
        mLoadAnimation.setDuration(1000);
        mLoadAnimation.setRepeatCount(Animation.INFINITE);
    }

    @Override
    public void show() {
        super.show();
        mLoadAnimation.start();
    }

    @Override
    public void dismiss() {
        super.dismiss();
        mLoadAnimation.cancel();
    }

}
