package tech.starwin.widget;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;

import com.qmuiteam.qmui.widget.dialog.QMUITipDialog;

import tech.starwin.utils.ui_utils.DialogFactory;
import tech.starwin.widget.LoadDialog;


/**
 * Created by SiKang on 2018/9/19.
 */
public class ProgressDialog {
    //loading dialog
    private Dialog loadingDialog;
    private Context context;

    public ProgressDialog(@NonNull Context context) {
        this.context = context;
        this.loadingDialog = new LoadDialog(context);
    }

    public ProgressDialog(@NonNull Dialog loadingDialog) {
        this.context = loadingDialog.getContext();
        this.loadingDialog = loadingDialog;
    }


    public void showLoading() {
        if (!loadingDialog.isShowing()) {
            loadingDialog.show();
        }
    }

    public void dissmissLoading() {
        if (loadingDialog.isShowing()) {
            loadingDialog.dismiss();
        }
    }

    @SuppressLint("CheckResult")
    public void showError(String msg) {
        final Dialog errorDialog = DialogFactory.createTipDialog(context, QMUITipDialog.Builder.ICON_TYPE_FAIL, msg);
        if (loadingDialog.isShowing())
            loadingDialog.dismiss();
        DialogFactory.showTiming(errorDialog, 1500);
    }


}
