package tech.starwin.mvp.api;


import android.support.annotation.NonNull;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.Observable;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

import com.common.bean.ActivityInfoBean;
import com.common.bean.BannerMessageDto;
import com.common.bean.BasicAck;
import com.common.bean.ContactBean;
import com.common.bean.ContactInfoBean;
import com.common.bean.CouponBean;
import com.common.bean.DisplayBean;
import com.common.bean.EmploymentServerBean;
import com.common.bean.GatewayInfoBean;
import com.common.bean.InviteeBean;
import com.common.bean.InviteePersonBean;
import com.common.bean.LoaningAmoutBean;
import com.common.bean.MsgInboxBean;
import com.common.bean.PersonalInfoServerBean;
import com.common.bean.PhotoListBean;
import com.common.bean.RecordFilesResponse;
import com.common.bean.RegionBean;
import com.common.bean.SysDictBean;
import com.common.bean.ThirdPartDataBean;
import com.common.bean.ThirdPartItemBean;
import com.common.bean.ThirdPartListBean;
import com.common.bean.TokenInfoBean;
import com.common.bean.UserBankInfo;
import com.common.bean.UserBean;
import com.common.bean.YWUser;

/**
 * Created by SiKang on 2018/9/14.
 * 和用户相关的API
 */
public interface UserApi {

    /**
     * 发送验证码
     */
    @FormUrlEncoded
    @POST("oksrz/hrmbsls")
    Observable<BasicAck> sendSms(@Field("mobile") String mobile);

    /**
     * 登录
     */
    @FormUrlEncoded
    @POST("oksrz/hrmbsli")
    Observable<TokenInfoBean> login(@Header("X-SMS-CODE") String smsCode,
                                    @Header("X-CAPTCHA-SID") String captchaSid,
                                    @Header("X-CAPTCHA") String captcha,
                                    @Field("mobile") String mobile,
                                    @Field("code") String code);

    /**
     * facebook accountKit登录
     */
    @FormUrlEncoded
    @POST("oksrz/hrmbslak")
    Observable<TokenInfoBean> accountKitLogin(@Field("mobile") String mobile, @Field("auth_code") String auth_code);

    /**
     * 退出登录
     */
    @POST("oksrz/hrmbslov")
    Observable<ResponseBody> logout(@Query("token") String token,
                                    @Query("tokenInvalid") String refreshToken);

    /**
     * 获取身份证照片
     */
    @GET("oksrz/hrmbcbdkpo")
    Observable<RecordFilesResponse> getKtpImg(@Header("X-AUTH-TOKEN") String token);


    /**
     * 上传firebase 推送图片
     */
    @FormUrlEncoded
    @PUT("oksrz/hrmbcbdft")
    Observable<ResponseBody> uploadFirebaseToken(@Field("firebase_token") String token);


    /**
     * 获取认证信息
     */
    @GET("oksrz/hrmbcbdpss")
    Observable<PersonalInfoServerBean> getPersonalInfo(@Header("X-AUTH-TOKEN") String token);

    /**
     * 用户信息
     */
    @GET("oksrz/hrmbnfcq")
    Observable<UserBean> getUserInfo(@Header("X-AUTH-TOKEN") String token);

    /**
     * 埋点
     */
    @GET("oksrz/hrmblpprq")
    Observable<ResponseBody> trackEvent(@Query("reportType") String reportType,
                                      @Query("actionType") String actionType,
                                      @Query("comment") String comment
    );


    /**
     * 学历列表
     */
    @GET("oksrz/hrmbswk/{type}")
    Observable<ArrayList<SysDictBean>> sysDict(@Path("type") String type);


    /**
     * 区域列表
     */
    @GET("oksrz/hrmblllp/{level}/{id}")
    Observable<RegionBean> getRegion(@Path("level") String level,
                                     @Path("id") int id
    );

    /**
     * 获取最新 Gateway 信息
     */
    @GET
    Observable<GatewayInfoBean> getGateway(@Url String url);


    /**
     * 提交联系人信息
     */
    @FormUrlEncoded
    @PUT("oksrz/hrmbcbdrct")
    Observable<ResponseBody> submitContactInfo(@Field("parentName") String parentName,
                                               @Field("parentMobile") String parentMobile,
                                               @Field("friendName") String friendName,
                                               @Field("friendMobile") String friendMobile,
                                               @Header("X-AUTH-TOKEN") String token);

    @FormUrlEncoded
    @PUT("oksrz/hrmbcbdrct")
    Observable<ResponseBody> submitContactInfo(@Field("parentId") String parentId,
                                               @Field("parentName") String parentName,
                                               @Field("parentMobile") String parentMobile,
                                               @Field("parentType") String parentType,
                                               @Field("friendId") String friendId,
                                               @Field("friendName") String friendName,
                                               @Field("friendMobile") String friendMobile,
                                               @Field("friendType") String friendType,
                                               @Field("friendId1") String friendId1,
                                               @Field("friendName1") String friendName1,
                                               @Field("friendMobile1") String friendMobile1,
                                               @Field("friendType1") String friendType1,
                                               @Header("X-AUTH-TOKEN") String token);


    @GET("/oksrz/hrmbcbdrecl")
    Observable<List<ContactBean>> getContactList();

    @Headers("Content-Type: application/json")
    @PUT("/oksrz/hrmbcbdrec")
    Observable<BasicAck> submitContactList(@Body List<ContactBean> contactList);


    /**
     * 提交工作认证信息
     */
    @FormUrlEncoded
    @PUT("oksrz/hrmbcbdreem")
    Observable<ResponseBody> submitEmploymentInfo(@Field("companyName") String companyName,
                                                  @Field("companyProvince") String companyProvince,
                                                  @Field("companyCity") String companyCity,
                                                  @Field("companyDistrict") String companyDistrict,
                                                  @Field("companyArea") String companyArea,
                                                  @Field("companyAddress") String companyAddress,
                                                  @Field("companyPhone") String companyPhone,
                                                  @Field("profession") String profession,
                                                  @Field("salary") String salary,
//                                                  @Field("workEmail") String workEmail,
                                                  @Header("X-AUTH-TOKEN") String token);


    /**
     * 提交个人信息
     */
    @FormUrlEncoded
    @PUT("oksrz/hrmbcbdpss")
    Observable<ResponseBody> submitPersonalInfo(@Field("fullName") String fullName,
                                                @Field("credentialNo") String credentialNo,
                                                @Field("familyNameInLaw") String familyNameInLaw,
                                                @Field("gender") String gender,
                                                @Field("province") String province,
                                                @Field("city") String city,
                                                @Field("district") String district,
                                                @Field("area") String area,
                                                @Field("address") String address,
                                                @Field("lastEducation") String lastEducation,
                                                @Field("maritalStatus") String maritalStatus,
                                                @Field("childrenNumber") String childrenNumber,
                                                @Field("residenceDuration") String residenceDuration,
                                                @Field("facebookId") String facebookId,
                                                @Field("whatsappId") String whatsappId,
                                                @Header("X-AUTH-TOKEN") String token);


    /**
     * 退出登录
     */
    @FormUrlEncoded
    @POST("oksrz/hrmbslov")
    Observable<ResponseBody> logout(@Field("token") String token);


    /**
     * 消息列表
     */
    @GET("oksrz/hrmbnfall")
    Observable<List<MsgInboxBean>> getMsgInbox(@Header("X-AUTH-TOKEN") String token);


    /**
     * 已读消息列表
     */
    @FormUrlEncoded
    @POST("oksrz/hrmbnfred")
    Observable<ResponseBody> sendReadMsg(@Field("msgId") String msgId,
                                         @Header("X-AUTH-TOKEN") String token);


    /**
     * 获取联系人信息
     */
    @GET("oksrz/hrmbcbdrct")
    Observable<ContactInfoBean> getContactInfo(@Header("X-AUTH-TOKEN") String token);

    /**
     * 获取工作认证信息
     */
    @GET("oksrz/hrmbcbdreem")
    Observable<EmploymentServerBean> getEmploymentInfo(@Header("X-AUTH-TOKEN") String token);


    /**
     * 最新版本号
     */
    @GET("oksrz/hrmbrlsm")
    Observable<ResponseBody> getVersionInfo();


    /**
     * 获取邀请码
     */
    @GET("oksrz/hrmbvimck")
    Observable<ResponseBody> getInviteCode(@Header("X-AUTH-TOKEN") String token);

    @GET("oksrz/hrmbvimi")
    Observable<InviteeBean> getInviteInfo(@Header("X-AUTH-TOKEN") String token);

    /**
     * 已邀请的用户
     */
    @GET("oksrz/hrmbvimil")
    Observable<ArrayList<InviteePersonBean>> getInvitedList(@Header("X-AUTH-TOKEN") String token);

    /**
     * 获取可用优惠券
     */
    @GET("oksrz/hrmbuaev")
    Observable<List<CouponBean>> getAvailableCoupon(@Header("X-AUTH-TOKEN") String token);

    /**
     * 获取已使用的优惠券
     */
    @GET("oksrz/hrmbuuscq")
    Observable<List<CouponBean>> getUsedCoupon(@Header("X-AUTH-TOKEN") String token);

    /**
     * 获取过期优惠券
     */
    @GET("oksrz/hrmbuout")
    Observable<List<CouponBean>> getOutdatedCoupon(@Header("X-AUTH-TOKEN") String token);

    /**
     * 获取活动Bannder信息
     */
    @GET("oksrz/hrmbbnhy")
    Observable<List<ActivityInfoBean>> getActivityList();

    /**
     * 贷款详情
     */
    @GET("oksrz/hrmblplrade")
    Observable<LoaningAmoutBean> getLoanAmoutData(@Query("principal") double amount,
                                                  @Query("period") int day,
                                                  @Query("periodUnit") String periodUnit,
                                                  @Query("productId") long productId);

    /**
     * 客户服务热线、公司介绍
     */
    @GET("oksrz/hrmblpldis")
    Observable<DisplayBean> display();


    @GET("oksrz/hrmbcbdepho")
    Observable<RecordFilesResponse> getJobImg(@Header("X-AUTH-TOKEN") String token);


    @GET("oksrz/hrmbcbdfjd")
    Observable<UserBankInfo> getBankCardInfo(@Header("X-AUTH-TOKEN") String token);


    @GET("oksrz/hrmbavbz")
    Observable<YWUser> getChatUserInfo(@Header("X-AUTH-TOKEN") String token);


    /**
     * 绑定的第三方账号
     */
    @GET("oksrz/hrmbcbdthda")
    Observable<ThirdPartDataBean> getThirdPartAccount(@Header("X-AUTH-TOKEN") String token);

    /**
     * 同盾列表
     */
    @GET("oksrz/hrmbcbdthdl")
    Observable<List<ThirdPartItemBean>> getThirdPartList(@Header("X-AUTH-TOKEN") String token);



    /**
     * 同盾列表V2
     */
    @GET("oksrz/hrmbcbdthdlto")
    Observable<ThirdPartListBean> getThirdPartListV2(@Header("X-AUTH-TOKEN") String token);

    /**
     * 公告
     */
    @GET("oksrz/hrmbbnmsk")
    Observable<List<BannerMessageDto>> getBannerMsg();

    /**
     * 获取其他证明图片列表
     */
    @GET("/oksrz/hrmbcbdrfe")
    Observable<PhotoListBean> getPhotoList();


    /**
     * 提交第三方数据
     */
    @PUT("oksrz/hrmbcbdthda")
    Observable<ResponseBody> submitThirdPartData(@Header("X-AUTH-TOKEN") String token,
                                                 @Query("dataChannel") String dataChannel,
                                                 @Query("dataType") String dataType,
                                                 @Query("taskId") String taskId,
                                                 @Query("credentialNo") String credentialNo,
                                                 @Query("realName") String realName,
                                                 @Query("mobile") String mobile,
                                                 @Query("passbackparams") String passbackparams);


}
