package tech.starwin.base;

import android.content.Context;
import android.content.res.Configuration;
import android.support.multidex.MultiDexApplication;

import tech.starwin.LibConfig;
import tech.starwin.utils.context_utils.AppLanguageUtils;

/**
 * Created by SiKang on 2018/11/2.
 */
public abstract class BaseApplication extends MultiDexApplication {

    @Override
    protected void attachBaseContext(Context base) {
        initLibCnofig();
        super.attachBaseContext(AppLanguageUtils.attachBaseContext(base, LibConfig.LANGUAGE));
    }


    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        AppLanguageUtils.setLanguage(this, LibConfig.LANGUAGE);
    }


    @Override
    public void onCreate() {
        super.onCreate();
        AppLanguageUtils.setLanguage(this, LibConfig.LANGUAGE);
        LibConfig.initLib(this);
        afterOnCreate();
    }

    public abstract void afterOnCreate();

    public abstract void initLibCnofig();




}
