package tech.starwin.mvp.api;


import android.support.annotation.NonNull;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.Observable;
import okhttp3.ResponseBody;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import tech.starwin.mvp.beans.ActivityInfoBean;
import tech.starwin.mvp.beans.BankBean;
import tech.starwin.mvp.beans.BannerMessageDto;
import tech.starwin.mvp.beans.BasicAck;
import tech.starwin.mvp.beans.ContactInfoBean;
import tech.starwin.mvp.beans.CouponBean;
import tech.starwin.mvp.beans.DepositMethodsBean;
import tech.starwin.mvp.beans.DepositResponseBean;
import tech.starwin.mvp.beans.DisplayBean;
import tech.starwin.mvp.beans.EmploymentServerBean;
import tech.starwin.mvp.beans.GatewayInfoBean;
import tech.starwin.mvp.beans.HistoryLoanAppInfoBean;
import tech.starwin.mvp.beans.InviteeBean;
import tech.starwin.mvp.beans.InviteePersonBean;
import tech.starwin.mvp.beans.LoanRange;
import tech.starwin.mvp.beans.LoaningAmoutBean;
import tech.starwin.mvp.beans.MsgInboxBean;
import tech.starwin.mvp.beans.PersonalInfoServerBean;
import tech.starwin.mvp.beans.ProgressBean;
import tech.starwin.mvp.beans.RecordFilesResponse;
import tech.starwin.mvp.beans.RegionBean;
import tech.starwin.mvp.beans.Result;
import tech.starwin.mvp.beans.SysDictBean;
import tech.starwin.mvp.beans.ThirdPartDataBean;
import tech.starwin.mvp.beans.TokenInfoBean;
import tech.starwin.mvp.beans.UserBankInfo;
import tech.starwin.mvp.beans.UserBean;
import tech.starwin.mvp.beans.YWUser;

/**
 * Created by SiKang on 2018/9/14.
 * 和用户相关的API
 */
public interface UserApi {

    /**
     * 发送验证码
     */
    @FormUrlEncoded
    @POST("auth/login/sms")
    Observable<BasicAck> sendSms(@Field("mobile") String mobile);

    /**
     * 登录
     */
    @FormUrlEncoded
    @POST("auth/login")
    Observable<TokenInfoBean> login(@Header("X-SMS-CODE") String smsCode,
                                    @Header("X-CAPTCHA-SID") String captchaSid,
                                    @Header("X-CAPTCHA") String captcha,
                                    @Field("mobile") String mobile,
                                    @Field("code") String code);

    /**
     * facebook accountKit登录
     */
    @FormUrlEncoded
    @POST("auth/login_account_kit")
    Observable<TokenInfoBean> accountKitLogin(@Field("mobile") String mobile, @Field("auth_code") String auth_code);

    /**
     * 退出登录
     */
    @POST("auth/logout")
    Observable<ResponseBody> logout(@Query("token") String token,
                                    @Query("tokenInvalid") String refreshToken);

    /**
     * 获取身份证照片
     */
    @GET("record/ktp-photo")
    Observable<RecordFilesResponse> getKtpImg(@Header("X-AUTH-TOKEN") String token);

    /**
     * 获取认证信息
     */
    @GET("record/personalinfo")
    Observable<PersonalInfoServerBean> getPersonalInfo(@Header("X-AUTH-TOKEN") String token);

    /**
     * 用户信息
     */
    @GET("info/infocenter")
    Observable<UserBean> getUserInfo(@Header("X-AUTH-TOKEN") String token);

    /**
     * 学历列表
     */
    @GET("sysdict/{type}")
    Observable<ArrayList<SysDictBean>> sysDict(@Path("type") String type);


    /**
     * 区域列表
     */
    @GET("region/{level}/{id}")
    Observable<RegionBean> getRegion(@Path("level") String level,
                                     @Path("id") int id
    );

    /**
     * 获取最新 Gateway 信息
     */
    @GET
    Observable<GatewayInfoBean> getGateway(@Url String url);


    /**
     * 提交联系人信息
     */
    @FormUrlEncoded
    @PUT("record/contact")
    Observable<ResponseBody> submitContactInfo(@Field("parentName") String parentName,
                                               @Field("parentMobile") String parentMobile,
                                               @Field("friendName") String friendName,
                                               @Field("friendMobile") String friendMobile,
                                               @Header("X-AUTH-TOKEN") String token);

    /**
     * 提交工作认证信息
     */
    @FormUrlEncoded
    @PUT("record/employment")
    Observable<ResponseBody> submitEmploymentInfo(@Field("companyName") String companyName,
                                                  @Field("companyProvince") String companyProvince,
                                                  @Field("companyCity") String companyCity,
                                                  @Field("companyDistrict") String companyDistrict,
                                                  @Field("companyArea") String companyArea,
                                                  @Field("companyAddress") String companyAddress,
                                                  @Field("companyPhone") String companyPhone,
                                                  @Field("profession") String profession,
                                                  @Field("salary") String salary,
//                                                  @Field("workEmail") String workEmail,
                                                  @Header("X-AUTH-TOKEN") String token);


    /**
     * 提交个人信息
     */
    @FormUrlEncoded
    @PUT("record/personalinfo")
    Observable<ResponseBody> submitPersonalInfo(@Field("fullName") String fullName,
                                                @Field("credentialNo") String credentialNo,
                                                @Field("familyNameInLaw") String familyNameInLaw,
                                                @Field("gender") String gender,
                                                @Field("province") String province,
                                                @Field("city") String city,
                                                @Field("district") String district,
                                                @Field("area") String area,
                                                @Field("address") String address,
                                                @Field("lastEducation") String lastEducation,
                                                @Field("maritalStatus") String maritalStatus,
                                                @Field("childrenNumber") String childrenNumber,
                                                @Field("residenceDuration") String residenceDuration,
                                                @Field("facebookId") String facebookId,
                                                @Header("X-AUTH-TOKEN") String token);

    /**
     * 刷新token
     */
    @POST("auth/refresh")
    Observable<Result<TokenInfoBean>> refreshToken(@Query("mobile") String mobile,
                                                   @Query("tokenInvalid") String refreshToken);

    /**
     * 退出登录
     */
    @FormUrlEncoded
    @POST("auth/logout")
    Observable<ResponseBody> logout(@Field("token") String token);


    /**
     * 消息列表
     */
    @GET("info/inbox/all")
    Observable<List<MsgInboxBean>> getMsgInbox(@Header("X-AUTH-TOKEN") String token);


    /**
     * 已读消息列表
     */
    @FormUrlEncoded
    @POST("info/inbox/read")
    Observable<ResponseBody> sendReadMsg(@Field("msgId") String msgId,
                                         @Header("X-AUTH-TOKEN") String token);


    /**
     * 获取联系人信息
     */
    @GET("record/contact")
    Observable<ContactInfoBean> getContactInfo(@Header("X-AUTH-TOKEN") String token);

    /**
     * 获取工作认证信息
     */
    @GET("record/employment")
    Observable<EmploymentServerBean> getEmploymentInfo(@Header("X-AUTH-TOKEN") String token);


    /**
     * 最新版本号
     */
    @GET("version/latest")
    Observable<ResponseBody> getVersionInfo();


    /**
     * 获取邀请码
     */
    @GET("invitation/mine/code")
    Observable<ResponseBody> getInviteCode(@Header("X-AUTH-TOKEN") String token);

    @GET("invitation/mine/invitee")
    Observable<InviteeBean> getInviteInfo(@Header("X-AUTH-TOKEN") String token);

    /**
     * 已邀请的用户
     */
    @GET("invitation/mine/invitee/list")
    Observable<ArrayList<InviteePersonBean>> getInvitedList(@Header("X-AUTH-TOKEN") String token);

    /**
     * 获取可用优惠券
     */
    @GET("coupon/available")
    Observable<List<CouponBean>> getAvailableCoupon(@Header("X-AUTH-TOKEN") String token);

    /**
     * 获取已使用的优惠券
     */
    @GET("coupon/used")
    Observable<List<CouponBean>> getUsedCoupon(@Header("X-AUTH-TOKEN") String token);

    /**
     * 获取过期优惠券
     */
    @GET("coupon/outdated")
    Observable<List<CouponBean>> getOutdatedCoupon(@Header("X-AUTH-TOKEN") String token);

    /**
     * 获取活动Bannder信息
     */
    @GET("banner")
    Observable<ArrayList<ActivityInfoBean>> getActivityList();

    /**
     * 贷款详情
     */
    @GET("loanapp/repayment-amount-detail")
    Observable<LoaningAmoutBean> getLoanAmoutData(@Query("principal") double amount,
                                                  @Query("period") int day,
                                                  @Query("periodUnit") String periodUnit,
                                                  @Query("productId") long productId);

    /**
     * 客户服务热线、公司介绍
     */
    @GET("loanapp/display")
    Observable<DisplayBean> display();


    @GET("record/employ-photo")
    Observable<RecordFilesResponse> getJobImg(@Header("X-AUTH-TOKEN") String token);


    @GET("record/bankcard")
    Observable<UserBankInfo> getBankCardInfo(@Header("X-AUTH-TOKEN") String token);

    @GET("banner")
    Observable<List<BannerMessageDto>> getBannerMessageList();


    @GET("chat/account")
    Observable<YWUser> getChatUserInfo(@Header("X-AUTH-TOKEN") String token);


    /**
     * 绑定的第三方账号
     */
    @GET("record/thirdparty_data")
    Observable<ThirdPartDataBean> getThirdPartAccount(@Header("X-AUTH-TOKEN") String token);

    /**
     * 提交第三方数据
     */
    @PUT("record/thirdparty_data")
    Observable<ResponseBody> submitThirdPartData(@Header("X-AUTH-TOKEN") String token,
                                                 @Query("dataChannel") String dataChannel,
                                                 @Query("dataType") String dataType,
                                                 @Query("taskId") String taskId,
                                                 @Query("credentialNo") String credentialNo,
                                                 @Query("realName") String realName,
                                                 @Query("mobile") String mobile,
                                                 @Query("passbackparams") String passbackparams);


}
