package com.oliveapp.liveness.sample.liveness;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Base64;
import android.widget.Toast;

import com.oliveapp.face.livenessdetectorsdk.livenessdetector.datatype.LivenessDetectionFrames;
import com.oliveapp.face.livenessdetectorsdk.livenessdetector.datatype.OliveappFaceInfo;
import com.oliveapp.libcommon.utility.LogUtil;
import com.oliveapp.liveness.sample.SampleUnusualResultActivity;
import com.oliveapp.liveness.sample.liveness.view_controller.LivenessDetectionMainActivity;


/**
 * 样例活体检测Activity
 */
public class SampleLivenessActivity extends LivenessDetectionMainActivity {

    public static final String TAG = SampleLivenessActivity.class.getSimpleName();
    private ProgressDialog mProgressDialog;

    public static String resultString = null;

    private LivenessDetectionFrames livenessDetectionFrames;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // 如果有设置全局包名的需要, 在这里进行设置
//        PackageNameManager.setPackageName();
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    /**
     * =====================启动算法===============
     **/
    @Override
    public void onInitializeSucc() {
        super.onInitializeSucc();
        super.startVerification();
    }

    @Override
    public void onInitializeFail(Throwable e) {
        super.onInitializeFail(e);
        LogUtil.e(TAG, "无法初始化活体检测...", e);
        Toast.makeText(this, "无法初始化活体检测", Toast.LENGTH_LONG).show();
        Intent i = new Intent(SampleLivenessActivity.this, SampleUnusualResultActivity.class);
        i.putExtra(SampleUnusualResultActivity.keyToGetExtra, SampleUnusualResultActivity.INIT_FAIL);
        startActivity(i);
        finish();
    }

    @Override
    protected void onPause() {
        super.onPause();
        if ((mProgressDialog != null) && mProgressDialog.isShowing()) {
            mProgressDialog.dismiss();
            mProgressDialog = null;
        }
    }

    /**===================================活体检测算法的回调==================================**/
    /**
     * 活体检测成功的回调，同时获取大礼包
     * 成功回调的接口在1.7.a_hotfix被拆成了2步，不再使用该接口
     *
     * @param livenessDetectionFrames 活体检测抓取的图片
     * @param faceInfo                捕获到的人脸信息
     */
    @Override
    public void onLivenessSuccess(final LivenessDetectionFrames livenessDetectionFrames, OliveappFaceInfo faceInfo) {
        super.onLivenessSuccess(livenessDetectionFrames, faceInfo);

        this.livenessDetectionFrames = livenessDetectionFrames;
        CheckImagePackage checkImagePackage = new CheckImagePackage();
        checkImagePackage.execute();
    }

    /*@Override
    public void onLivenessSuccess(OliveappFaceInfo oliveappFaceInfo) {
        super.onLivenessSuccess(null, oliveappFaceInfo);
        CheckImagePackage checkImagePackage = new CheckImagePackage();
        checkImagePackage.execute();
    }*/

    /**
     * 活检阶段失败
     */
    @Override
    public void onLivenessFail(int result, LivenessDetectionFrames livenessDetectionFrames) {

        super.onLivenessFail(result, livenessDetectionFrames);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
//                Intent intent = new Intent();
//                Bundle bundle = new Bundle();
//                bundle.putString("FACE_RESULT", null);
//                intent.putExtras(bundle);
                setResult(Activity.RESULT_OK);
                finish();
            }
        });
    }

    /**
     * 获取大礼包并访问私有云的样例代码，集成时请不要使用
     */
    private class CheckImagePackage extends AsyncTask<Void, Void, String> {

        @Override
        protected void onPreExecute() {
            mProgressDialog = ProgressDialog.show(SampleLivenessActivity.this,
                    null, "正在比对，请稍等", true, false);
        }

        @Override
        protected String doInBackground(Void... voids) {
            // 获取大礼包，耗时操作，不可在UI线程执行
            return Base64.encodeToString(livenessDetectionFrames.verificationData, Base64.NO_WRAP);
        }


        @Override
        protected void onPostExecute(final String result) {
            if (mProgressDialog != null) {
                mProgressDialog.dismiss();
            }
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
//                    Intent intent = new Intent();
//                    Bundle bundle = new Bundle();
//                    bundle.putString("FACE_RESULT", result);
//                    intent.putExtras(bundle);
                    resultString = result;
                    setResult(Activity.RESULT_OK);
                    finish();
                }
            });
        }
    }

    public static class YituFaceResult{
        public String resultString;
        public YituFaceResult(String result){
            resultString = result;
        }
    }
}
