from core.db_util import DbUtils
from common import logger

logger = logger.get_logger(__name__)


class LoanDao(object):

    @classmethod
    def get_reapply_loan(cls, reapply_count):
        sql = """select t_loan_app.id as loan_app_id,t_loan_app.status loan_status,imei,t_loan_app_status_log.create_time as prereview_time,
                    t_customer.id as customer_id,t_customer.mobile as mobile,foo.is_overdue is_overdue
                    from (
                    select customer_id,
                      count(1) loan_with_result,
                      sum(case when t_loan_app.status in ('GRACE_PERIOD','OVERDUE') then 1 else 0 end) as is_overdue,
                      sum(case when t_loan_app.status='PAID_OFF'  then 1 else 0 end) as paid_off_count,
                      sum(case when t_loan_app.status='PAID_OFF' and t_loan_app.sub_status<>'M0' then 1 else 0 end) as paid_off_m1_count,
                      max(case when t_loan_app.status='PAID_OFF' then id else null end) latest_paid_off_id,
                        max(id) latest_loan_id

                    from t_loan_app
                    where t_loan_app.status in ('GRACE_PERIOD','OVERDUE','PAID_OFF')
                    group by customer_id) foo
                      left join t_loan_app on foo.latest_loan_id=t_loan_app.id
                      left join t_loan_app_status_log
                        on t_loan_app.id=t_loan_app_status_log.loan_app_id and t_loan_app_status_log.old_status='PRE_REVIEW'
                      left join t_customer on t_loan_app.customer_id=t_customer.id
                    where foo.loan_with_result>=%d ;
        """ % reapply_count

        db = DbUtils()

        results = db.select_with_column(sql)

        return results
