from .loan_dao import LoanDao
import requests
from config import risk_url
from common import logger
import json
import pandas as pd

logger = logger.get_logger(__name__)


def call_risk_api(loan_app_id):
    params = {'loanAppId': loan_app_id}

    try:
        response = requests.get(risk_url, params=params)

        result = json.loads(response.text)

        return result
    except Exception as e:
        logger.error('call_risk_api error,%s,%s', loan_app_id, response, exc_info=True)

    return None


def rule_regression(reapply_count=2):
    regression_results = []
    count = 0
    for row in LoanDao.get_reapply_loan(reapply_count=reapply_count):

        try:
            loan_app_id = row.get('loan_app_id')
            customer_id = row.get('customer_id')
            is_overdue = row.get('is_overdue')

            result = call_risk_api(loan_app_id)

            conclusion = None
            rule = None
            if result:
                conclusion = result.get('result')
                rule = result.get('rule')

            regression_result = [loan_app_id, customer_id, is_overdue, conclusion, rule]

            regression_results.append(regression_result)

            count += 1
        except Exception as e:
            logger.error('rule regression error:%s', loan_app_id, exc_info=True)

        if count % 100 == 0:
            logger.info('run regression %d', count)

    regression_results_df = pd.DataFrame(regression_results,
                                         columns=['loan_app_id', 'customer_id', 'is_overdue', 'conclusion', 'rule'])

    return regression_results_df
