import time


def timeit(func):
    def wrap(*args):
        start_time = time.time()
        result = func(*args)

        print("%s running time: %2.2f sec" % (func.__name__, time.time() - start_time))

        return result

    wrap.unwrapped = func

    return wrap
