from common import logger
from . import connection

logger = logger.get_logger(__name__)


class DbUtils:
    # pg
    def __init__(self):

        self.cur = connection.cursor()

    def close_cursor(self):

        self.cur.close()

    def insert(self, sql, args):

        try:
            self.cur.execute(sql, args)
            self.connection.commit()
        except Exception as e:
            logger.error('========> SQL[%s] insert error: %s', sql, str(e))

    def select(self, sql):

        records = []

        try:
            self.cur.execute(sql)
            records = self.cur.fetchall()
        except Exception as e:
            logger.error('========> SQL[%s] select error: %s', sql, str(e))

        return records

    def get_columns_last_query(self):
        return [desc[0] for desc in self.cur.description]

    def select_with_column(self, sql):

        results = self.select(sql)
        cols = self.get_columns_last_query()

        return [dict(zip(cols, row)) for row in results]
